% This function calculates spatial correlation between a binary mask and
% molecular MSI data:

function [Correlation_Values,Top5mz] = Corr_BianryMask_MSI(Cluster_Mask, MS_DataCube)

%1. %Dilate the Binary Mask to take its surroundings in corr. considerations
se = strel('disk',10);
M_d = imdilate(Cluster_Mask,se);
Cluster_Maskd = imfill(M_d,'holes');
index_d = find(Cluster_Maskd==1); 
% figure, imagesc(Cluster_Maskd);

SS = size(MS_DataCube);
for i=1:SS(3)   
    mz = MS_DataCube(:,:,i); 
    mz_vector = double(mz(index_d)); %M/Z within the larger mask HIP_d

    mask_vector = double(Cluster_Mask(index_d));   %Sub-image taken from the HIP based on index_d
    R = corrcoef(mz_vector,mask_vector);
    Correlation_Values(i) = R(1,2);   
end
plot(Correlation_Values);
xlabel('M/Z Index');
ylabel('Correlation');

[sortedValues,sortIndex] = sort(Correlation_Values(:),'descend');
Top5mz = sortIndex(1:5); %Index of the top 5 correlated masses